/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class VibratingModifier
extends Modifier
implements ConditionalStatModifierHook,
ProjectileLaunchModifierHook {
    private static final Component SPEED = TConstruct.makeTranslation((String)"modifier", (String)"vibrating.speed");

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.PROJECTILE_LAUNCH);
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)Utils.vibratingEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)Utils.vibratingEffect.get()).apply(attacker, 100, effectLevel, true);
        }
        return 0;
    }

    public float beforeEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity attacker = context.getAttacker();
        return knockback * (1.0f + VibratingModifier.getBonus(attacker, Utils.vibratingEffect, level, 32.0f));
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(15, ((TinkerEffect)Utils.vibratingEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.vibratingEffect.get()).apply(shooter, 100, effectLevel, true);
            if (arrow != null) {
                arrow.m_36735_((int)(1.0f + VibratingModifier.getBonus(shooter, Utils.vibratingEffect, modifier.getLevel(), 16.0f)));
            }
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.ATTACK_SPEED) {
            return baseValue * (1.0f - VibratingModifier.getBonus(living, Utils.vibratingEffect, 1, 32.0f));
        }
        if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.0f - VibratingModifier.getBonus(living, Utils.vibratingEffect, 1, 64.0f));
        }
        return baseValue;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            float bonus = VibratingModifier.getBonus((LivingEntity)player, Utils.vibratingEffect, level, 32.0f);
            if (player != null && key == TooltipKey.SHIFT && bonus > 0.0f) {
                if (harvest) {
                    this.addPercentTooltip((Component)new TranslatableComponent("vibrating.knockback"), bonus, tooltip);
                    this.addPercentTooltip((Component)new TranslatableComponent("vibrating.attack_speed"), -bonus, tooltip);
                } else {
                    this.addPercentTooltip((Component)new TranslatableComponent("vibrating.punch"), bonus * 2.0f, tooltip);
                    this.addPercentTooltip((Component)new TranslatableComponent("vibrating.draw_speed"), 1.0f - bonus / 2.0f, tooltip);
                }
            }
        }
    }
}

